<?php

App::uses('AppModel', 'Model');

/**
 * Plan Model
 *
 * @property User $User
 */
class Plan extends AppModel
{

    /**
     * hasMany associations
     *
     * @var array
     */
    public $hasMany = array('User');

    /**
     * Validation rules
     *
     * @var array
     */
    public $validate = array(
        'title'        => array(
            'notBlank' => array(
                'rule' => array( 'notBlank' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'redirections' => array(
            'boolean' => array(
            //'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'stats'        => array(
            'numeric' => array(
                'rule' => array( 'numeric' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'api'          => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'timer'        => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'comments'     => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'sharing'      => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'feed'         => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'ads_area1'    => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
        'ads_area2'    => array(
            'boolean' => array(
                'rule' => array( 'boolean' ),
            //'message' => 'Your custom message here',
            //'allowEmpty' => false,
            //'required' => false,
            //'last' => false, // Stop validation after this rule
            //'on' => 'create', // Limit validation to 'create' or 'update' operations
            ),
        ),
    );

    public function beforeSave($options = array())
    {

        if (is_array($this->data[ 'Plan' ][ 'redirections' ])) {
            $this->data[ 'Plan' ][ 'redirections' ] = serialize($this->data[ 'Plan' ][ 'redirections' ]);
        }

        return true;
    }

    public function afterFind($results, $primary = false)
    {

        foreach ($results as $key => $val) {
            if (isset($val[ 'Plan' ][ 'redirections' ]) && $this->is_serialized($val[ 'Plan' ][ 'redirections' ])) {
                $results[ $key ][ 'Plan' ][ 'redirections' ] = unserialize($val[ 'Plan' ][ 'redirections' ]);
            }
        }

        return $results;
    }

    // check this if error happened
// https://core.trac.wordpress.org/browser/tags/4.0.1/src/wp-includes/functions.php#L283
    function is_serialized($data)
    {
        if (@unserialize($data) === false) {
            return false;
        } else {
            return true;
        }
    }
    
    public function afterDelete()
    {
        
        App::uses('ClassRegistry', 'Utility');
        
        $userModel = ClassRegistry::init('User');
        
        $userModel->updateAll(
            array(
                'User.plan_id' => 1
            ),
            array('User.plan_id' => $this->id)
        );

    }
}
